uniform sampler2D s_tex0;

uniform vec4  cloudColor;
uniform float cloudInvScale;
uniform vec2 cloudSpeed;
uniform float density;
uniform float detailInvScale;
uniform vec2 detailSpeed;
uniform vec2  sunDirection;
uniform float time;
uniform float scale;
 
varying vec4 texCoord;
 
void main(void)
{
   vec2 cloudOffset  = cloudSpeed  * time;
   vec2 detailOffset = detailSpeed * time;
 
	vec2 scaledTexCoord = texCoord.xy * scale;

   float a1 = texture2D (s_tex0, (scaledTexCoord + cloudOffset ) * cloudInvScale ).a;
   float a2 = texture2D (s_tex0, (scaledTexCoord + detailOffset) * detailInvScale).a;
   
   vec2 p_sunDirection = normalize (sunDirection) * -0.01;
 
   vec4 color = cloudColor;
   color.a = clamp ((a1 + a2), 0.0, density);
 
	vec3  absorption = vec3(0);
	absorption = (texture2D (s_tex0, (scaledTexCoord + p_sunDirection * 0.2 + cloudOffset ) * cloudInvScale ).rgb +
				  texture2D (s_tex0, (scaledTexCoord + p_sunDirection * 0.2 + detailOffset) * detailInvScale).rgb)
				+(texture2D (s_tex0, (scaledTexCoord + p_sunDirection * 0.4 + cloudOffset)  * cloudInvScale ).rgb +
				  texture2D (s_tex0, (scaledTexCoord + p_sunDirection * 0.4 + detailOffset) * detailInvScale).rgb)
				+(texture2D (s_tex0, (scaledTexCoord + p_sunDirection * 0.6 + cloudOffset)  * cloudInvScale ).rgb +
				  texture2D (s_tex0, (scaledTexCoord + p_sunDirection * 0.6 + detailOffset) * detailInvScale).rgb)
				+(texture2D (s_tex0, (scaledTexCoord + p_sunDirection * 0.8 + cloudOffset)  * cloudInvScale ).rgb +
	 		      texture2D (s_tex0, (scaledTexCoord + p_sunDirection * 0.8 + detailOffset) * detailInvScale).rgb)
				+(texture2D (s_tex0, (scaledTexCoord + p_sunDirection * 1.0 + cloudOffset)  * cloudInvScale ).rgb +
				  texture2D (s_tex0, (scaledTexCoord + p_sunDirection * 1.0 + detailOffset) * detailInvScale).rgb);
  
	color.rgb *= absorption * 0.1;
	
	gl_FragColor = color;
}
